// Boids.js

function buildUI( obj ) {
  
  obj.setParameter("name", "Boxcel");
  
  obj.addParameterString("image file", "", false);
  obj.addParameterButton("set image", "Set", "setImageFile");

  obj.addParameterSeparator("size");

  obj.addParameterInt("pixel width", 10, 1, 1000, true, true);
  obj.addParameterInt("pixel height", 10, 1, 1000, true, true);

  obj.addParameterFloat("pixel size", 1, 0, 10000, true, true);

}

function buildObject( obj ) {
  var imagePath = obj.getParameter("image file");
  var imageFile = new File( imagePath );
  if (imageFile && imageFile.exist()) {

    var pixelWidth = obj.getParameter("pixel width");
    var pixelHeight = obj.getParameter("pixel height");
    var pixelSize = obj.getParameter("pixel size");

    var scriptFilePath = obj.scriptPath();
    var scriptFile = new File( scriptFilePath );
    var scriptPath = scriptFile.directory();
    var dataPath = '/tmp/boxcelData.data';


    OS.system(scriptPath.replace(/\s/g, "\\ ") + "/Boxcel\\ Helper " + 
      pixelWidth + " " + pixelHeight + " " + imagePath.replace(/\s/g, "\\ ") + " " + dataPath.replace(/ /g, '\\ '));

    /*
    print( "/Users/tg/Desktop/Boxcel\\ Helper/DerivedData/Boxcel\\ Helper/Build/Products/Debug/Boxcel\\ Helper " + 
      pixelWidth + " " + pixelHeight + " " + imagePath.replace(/\s/g, "\\ ") + " " + dataPath.replace(/ /g, '\\ '));
    */
    
    var offsetWidth = pixelWidth * pixelSize * -0.5;
    var offsetHeight = pixelHeight * pixelSize * 0.5;

    var core = obj.core();
    core.removeAllParticles();
    
    var dataFile = new File( dataPath );
    dataFile.open( READ_MODE, LITTLE_ENDIAN );

    if (!dataFile.isOpen()) {
      print( 'dataFile is not open: ' + dataPath );
      return;
    }

    var width = dataFile.readInt();
    var height = dataFile.readInt();

    for (var i = 0;i < width;i++ ) {
      for (var j = 0;j < height;j++ ) {
        var r = dataFile.readFloat();
        var g = dataFile.readFloat();
        var b = dataFile.readFloat();
        var a = dataFile.readFloat();

        var particle = core.addParticle();
        particle.setColor( new Vec4D( r, g, b, a ) );
        particle.setPosition( new Vec3D( offsetWidth + i * pixelSize, offsetHeight + j * pixelSize * -1, 0 ) );

        //print( i + ':' + j + ' ' + r.toFixed(3) + ', ' + g.toFixed(3) + ', ' + b.toFixed(3) + ', ' + a.toFixed(3) );

        var col = particle.getColor();
        //print( i + ':' + j + ' ' + col.x.toFixed(3) + ', ' + col.y.toFixed(3) + ', ' + col.z.toFixed(3) + ', ' + col.w.toFixed(3) );
      }
    }

    dataFile.close();

    //OS.system("rm " + dataPath.replace(/ /g, "\\ "));
  }
}

function setImageFile( obj ) {
  var path = OS.runOpenPanel("jpg", "png", "gif", "tiff");
  if (path == null) return;

  obj.setParameter("image file", path);
  obj.update();
}